<form action="<?php echo e(route('admin.third-party.payment-method.addon-payment-set')); ?>" method="POST"
      id="<?php echo e($gateway->key_name); ?>-form" enctype="multipart/form-data">
    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvas-<?php echo e($gateway->key_name); ?>"
         aria-labelledby="offcanvas-<?php echo e(str_replace('_',' ',$gateway->key_name)); ?>-Label">
        <div class="offcanvas-header bg-body">
            <h3 class="mb-0 text-capitalize">
                <?php echo e(translate('Setup')); ?> - <?php echo e(str_replace('_',' ',$gateway->key_name)); ?>

            </h3>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div class="p-12 p-sm-20 bg-section rounded mb-3 mb-sm-20">
                <h4 class="text-capitalize"><?php echo e(str_replace('_',' ', $gateway->key_name)); ?></h4>
                <p class="fs-12">
                    <?php echo e(translate('if_you_turn_off_customer_can_not_pay_through_this_payment_gateway')); ?>

                </p>

                <div class="border rounded px-3 py-2 d-flex justify-content-between align-items-center bg-white">
                    <h4 class="text-capitalize mb-0"><?php echo e(translate('Status')); ?></h4>

                    <?php ($additionalData = $gateway['additional_data'] != null ? json_decode($gateway['additional_data']) : []); ?>
                    <?php
                        if ($additionalData != null) {
                            $gatewayImgPath = $additionalData->gateway_image ? dynamicStorage(path: 'storage/app/public/payment_modules/gateway_image/' . $additionalData->gateway_image) : '';
                        } else {
                            $gatewayImgPath = dynamicAsset(path: 'public/assets/back-end/img/modal/payment-methods/' . $gateway->key_name . '.png');
                        }
                    ?>

                    <?php if(($gateway->is_active == 0 && $gateway->is_enabled_to_use) || ($gateway->is_active == 1)): ?>
                        <label class="switcher show-status-text">
                            <input
                                class="switcher_input custom-modal-plugin"
                                type="checkbox" value="1" name="status"
                                id="<?php echo e($gateway->key_name); ?>-canvas"
                                <?php echo e($gateway['is_active'] ? 'checked' : ''); ?>

                                data-modal-type="input-change"
                                data-on-image="<?php echo e($gatewayImgPath); ?>"
                                data-off-image="<?php echo e($gatewayImgPath); ?>"
                                data-on-title="<?php echo e(translate('want_to_Turn_ON_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                data-off-title="<?php echo e(translate('want_to_Turn_OFF_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                data-on-message="<p><?php echo e(translate('if_enabled_customers_can_use_this_payment_method')); ?></p>"
                                data-off-message="<p><?php echo e(translate('if_disabled_this_payment_method_will_be_hidden_from_the_checkout_page')); ?></p>">
                            <span class="switcher_control"></span>
                        </label>
                    <?php else: ?>
                        <label class="switcher" data-bs-toggle="modal" data-bs-target="#gateway-modal-<?php echo e($gateway['key_name']); ?>">
                            <input disabled
                                   class="switcher_input custom-modal-plugin"
                                   type="checkbox" value="1" name="status"
                                   id="<?php echo e($gateway->key_name); ?>-canvas"
                                   <?php echo e($gateway['is_active'] ? 'checked' : ''); ?>

                                   data-modal-type="input-change"
                                   data-on-image="<?php echo e($gatewayImgPath); ?>"
                                   data-off-image="<?php echo e($gatewayImgPath); ?>"
                                   data-on-title="<?php echo e(translate('want_to_Turn_ON_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                   data-off-title="<?php echo e(translate('want_to_Turn_OFF_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                   data-on-message="<p><?php echo e(translate('if_enabled_customers_can_use_this_payment_method')); ?></p>"
                                   data-off-message="<p><?php echo e(translate('if_disabled_this_payment_method_will_be_hidden_from_the_checkout_page')); ?></p>">
                            <span class="switcher_control"></span>
                        </label>
                    <?php endif; ?>
                </div>
            </div>

            <div class="p-12 p-sm-20 bg-section rounded mb-3 mb-sm-20">
                <h4><?php echo e(translate('Choose_Logo')); ?> <span class="text-danger">*</span></h4>
                <p class="fs-12"><?php echo e(translate('it_will_show_in_website_&_app.')); ?></p>

                <div class="upload-file">
                    <input type="file" name="gateway_image" class="upload-file__input single_file_input"
                           accept=".webp, .jpg, .jpeg, .png, .gif">
                    <label
                        class="upload-file__wrapper w-325">
                        <div class="upload-file-textbox text-center">
                            <img width="34" height="34" class="svg"
                                 src="<?php echo e(dynamicAsset(path: 'public/assets/new/back-end/img/svg/image-upload.svg')); ?>"
                                 alt="<?php echo e(translate('Gateway')); ?>">
                            <h6 class="mt-1 fw-medium lh-base text-center">
                                <span class="text-info"><?php echo e(translate('Click_to_upload')); ?></span>
                                <br>
                                <?php echo e(translate('or_drag_and_drop')); ?>

                            </h6>
                        </div>
                        <img class="upload-file-img" loading="lazy" 
                            src="<?php echo e(getValidImage(path:'storage/app/public/payment_modules/gateway_image/'.($additionalData->gateway_image ?? ''), type: 'backend-payment' )); ?>" 
                            data-default-src="<?php echo e(getValidImage(path:'storage/app/public/payment_modules/gateway_image/'.($additionalData->gateway_image ?? ''), type: 'backend-payment' )); ?>" 
                            alt="">
                    </label>
                    <div class="overlay">
                        <div class="d-flex gap-10 justify-content-center align-items-center h-100">
                            <button type="button" class="btn btn-outline-info icon-btn edit_btn">
                                <i class="fi fi-rr-camera"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <p class="fs-10 mt-3 text-center">
                    <?php echo e("JPG, JPEG, PNG Less Than 1MB"); ?>

                    <span class="fw-medium">(<?php echo e(translate('Ratio')); ?> <?php echo e('3 : 1'); ?>)</span>
                </p>
            </div>

            <div class="mb-3 mb-sm-20">
                <div class="p-12 p-sm-20 bg-section rounded">
                    <div class="card-body">
                        <input name="gateway" value="<?php echo e($gateway->key_name); ?>" hidden>
                        <div class="form-group">
                            <label class="form-label" for="">
                                <?php echo e(translate('Choose_Use_Type')); ?>

                                <span class="text-danger">*</span>
                                <i class="fi fi-sr-info text-body-light" data-bs-custom-class="text-start"
                                   data-bs-toggle="tooltip" data-bs-html="true"
                                   data-bs-title="<div><?php echo e(translate('when_select_live_option')); ?>: <?php echo e(translate('during_use_this_from_website_or_app_need_real_required_data.')); ?> <?php echo e(translate('other_wise_this_gateway_can_not_work.')); ?></div>
                                        <div class='p-2'></div>
                                        <div><?php echo e(translate('when_select_live_option')); ?> : <?php echo e(translate('during_use_this_from_website_or_app_use_fake_required_data_to_test_payment_gateway_work_properly_or_not')); ?></div>"></i>
                            </label>
                            <?php ($mode = $gateway->live_values['mode']); ?>
                            <div class="min-h-40 d-flex align-items-center gap-4 border rounded mb-2 px-3 py-1">
                                <div class="form-check d-flex gap-1">
                                    <input class="form-check-input radio--input" type="radio" name="mode"
                                           id="live-<?php echo e($gateway->key_name); ?>" value="live" <?php echo e($mode == 'live' ? 'checked' : ''); ?> required>
                                    <label class="form-check-label" for="live-<?php echo e($gateway->key_name); ?>">
                                        <?php echo e(translate('live')); ?>

                                    </label>
                                </div>
                                <div class="form-check d-flex gap-1">
                                    <input class="form-check-input radio--input" type="radio" name="mode"
                                           id="test-<?php echo e($gateway->key_name); ?>" value="test" <?php echo e($mode == 'test' ? 'checked' : ''); ?> required>
                                    <label class="form-check-label" for="test-<?php echo e($gateway->key_name); ?>">
                                        <?php echo e(translate('test')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>

                        <?php if($gateway->key_name === 'paystack'): ?>
                            <?php ($skip=['gateway', 'mode', 'status', 'supported_country', 'callback_url']); ?>
                        <?php else: ?>
                            <?php ($skip=['gateway','mode','status', 'supported_country']); ?>
                        <?php endif; ?>
                        <?php $__currentLoopData = $gateway->live_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gatewayKey => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!in_array($gatewayKey , $skip)): ?>
                                <div class="mb-4">
                                    <label for="gateway-key-<?php echo e($gateway->key_name); ?>-<?php echo e($gatewayKey); ?>" class="form-label">
                                        <?php echo e(ucwords(str_replace('_',' ',$gatewayKey))); ?>

                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control"
                                           name="<?php echo e($gatewayKey); ?>"
                                           id="gateway-key-<?php echo e($gateway->key_name); ?>-<?php echo e($gatewayKey); ?>"
                                           placeholder="<?php echo e(ucwords(str_replace('_',' ',$gatewayKey))); ?> *"
                                           value="<?php echo e(env('APP_ENV') == 'demo' ? '' : $value); ?>">
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php ($supportedCountry = $gateway->live_values); ?>
                        <?php if(isset($supportedCountry['supported_country'])): ?>
                            <?php ($supportedCountry = $supportedCountry['supported_country']); ?>
                            <label for="<?php echo e($gateway->key_name); ?>-title" class="form-label">
                                <?php echo e(translate('supported_country')); ?> *
                            </label>
                            <div class="mb-2">
                                <select class="js-select form-control w-100" name="supported_country">
                                    <option value="egypt" <?php echo e($supportedCountry == 'egypt'?'selected':''); ?>>
                                        <?php echo e(translate('Egypt')); ?>

                                    </option>
                                    <option value="PAK" <?php echo e($supportedCountry == 'PAK'?'selected':''); ?>>
                                        <?php echo e(translate('Pakistan')); ?>

                                    </option>
                                    <option value="KSA" <?php echo e($supportedCountry == 'KSA'?'selected':''); ?>>
                                        <?php echo e(translate('Saudi Arabia')); ?>

                                    </option>
                                    <option value="oman" <?php echo e($supportedCountry == 'oman'?'selected':''); ?>>
                                        <?php echo e(translate('Oman')); ?>

                                    </option>
                                    <option value="UAE" <?php echo e($supportedCountry == 'UAE'?'selected':''); ?>>
                                        <?php echo e(translate('UAE')); ?>

                                    </option>
                                </select>
                            </div>
                        <?php endif; ?>

                        <div class="mb-4">
                            <label for="gateway-title-<?php echo e($gateway->key_name); ?>" class="form-label">
                                <?php echo e(translate('payment_gateway_title')); ?>

                                <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" name="gateway_title"
                                   id="gateway-title-<?php echo e($gateway->key_name); ?>"
                                   placeholder="<?php echo e(translate('payment_gateway_title')); ?>"
                                   value="<?php echo e($additionalData != null ? $additionalData->gateway_title : ''); ?>" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="offcanvas-footer shadow-lg">
            <div class="d-flex justify-content-center flex-wrap gap-3 bg-white px-3 py-2">
                <button type="reset" class="btn btn-secondary px-3 px-sm-4 flex-grow-1">
                    <?php echo e(translate('reset')); ?>

                </button>
                <button type="submit" class="btn btn-primary px-3 px-sm-4 flex-grow-1">
                    <?php echo e(translate('submit')); ?>

                </button>
            </div>
        </div>
    </div>
</form>
<?php /**PATH C:\laragon\www\Crowdfunding1\E-Africal Mall org\resources\views/admin-views/third-party/payment-method/_payment-gateways-offcanvas.blade.php ENDPATH**/ ?>