<?php use Illuminate\Support\Facades\Session; ?>



<?php $__env->startSection('title', translate('payment_Method')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/3rd-party.png')); ?>" alt="">
                <?php echo e(translate('payment_methods_setup')); ?>

            </h2>
        </div>

        <?php echo $__env->make('admin-views.third-party._third-party-payment-method-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="bg-warning bg-opacity-10 fs-12 px-12 py-10 text-dark rounded mb-3">
            <div class="d-flex gap-2 align-items-center mb-1">
                <i class="fi fi-sr-info text-warning"></i>
                <span>
                   <?php echo e(translate('here_you_can_configure_payment_gateways_by_obtaining_the_necessary_credentials')); ?> (<?php echo e(translate('e.g., _api_keys')); ?>) <?php echo e(translate('from_each_respective_payment_gateway_platform')); ?>.
                </span>
            </div>
            <ul class="m-0 ps-3">
                <li><?php echo e(translate('to_use_digital_payments,_you_need_to_set_up_at_least_one_payment_method')); ?></li>
                <li><?php echo e(translate('to_make_available_these_payment_options,_you_must_enable_the_digital_payment_option_from')); ?>

                    <a class="text-underline" href="<?php echo e(route('admin.business-settings.web-config.index')); ?>" target="_blank">
                        <?php echo e(translate('Business_Information')); ?>

                    </a>
                    <?php echo e(translate('page')); ?>

                </li>
            </ul>
        </div>

        <div class="bg-danger bg-opacity-10 fs-12 px-12 py-10 text-dark rounded d-flex gap-2 align-items-center mb-3">
            <i class="fi fi-sr-triangle-warning text-danger"></i>
            <span>
                <?php echo e(translate('currently_no_payment_gateway_supported_your_currency_active_at_least_one_gateway_that_support_your_currency._to_change_currency_setup_visit')); ?>

                <a href="<?php echo e(route('admin.system-setup.currency.view')); ?>" class="text-underline" target="_blank">
                    <?php echo e(translate('Currency')); ?>

                </a> <?php echo e(translate('page')); ?>

            </span>
        </div>

        <?php if($paymentGatewayPublishedStatus): ?>
            <div class="card mb-3">
                <div class="align-items-center card-body d-flex flex-wrap gap-3 justify-content-between">
                    <h4 class="text-danger bg-transparent m-0">
                        <?php echo e(translate('your_current_payment_settings_are_disabled,because_you_have_enabled_payment_gateway_addon').' '.translate('To_visit_your_currently_active_payment_gateway_settings_please_follow_the_link').'.'); ?>

                    </h4>
                    <a href="<?php echo e(!empty($paymentUrl) ? $paymentUrl : ''); ?>" class="btn btn-outline-primary">
                        <i class="fi fi-sr-settings"></i>
                        <?php echo e(translate('settings')); ?>

                    </a>
                </div>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">
                        <?php echo e(translate('Digital_Payment_Methods_List')); ?>

                    </h3>

                    <div class="form-group">
                        <div class="input-group">
                            <input type="search" id="payment-method-search" class="form-control min-w-300" placeholder="<?php echo e(translate('search_by_payment_method_name')); ?>">
                            <div class="input-group-append search-submit">
                                <button type="submit">
                                    <i class="fi fi-rr-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row gy-3" id="payment-gateway-cards">
                    <?php $__currentLoopData = $paymentGatewaysList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 payment-gateway-cards">
                            <div class="card shadow-2">
                                <?php ($mode = $gateway->live_values['mode'] ?? ''); ?>
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <h4 class="text-capitalize mb-0 d-flex gap-2 align-items-center">
                                        <?php echo e(str_replace('_',' ',$gateway->key_name)); ?>

                                        <span class="badge text-bg-info badge-info">
                                            <?php echo e($mode); ?>

                                        </span>
                                    </h4>

                                    <div class="d-flex gap-3 align-items-center">
                                        <?php ($additional_data = $gateway['additional_data'] != null ? json_decode($gateway['additional_data']) : []); ?>
                                        <?php
                                            if ($additional_data != null) {
                                                $img_path = $additional_data->gateway_image ? dynamicStorage(path: 'storage/app/public/payment_modules/gateway_image/'.$additional_data->gateway_image) : '';
                                                $img_path = $img_path != '' ? $img_path : dynamicAsset(path: 'public/assets/back-end/img/modal/payment-methods/'.$gateway->key_name.'.png');
                                            } else {
                                                $img_path = dynamicAsset(path: 'public/assets/back-end/img/modal/payment-methods/'.$gateway->key_name.'.png');
                                            }
                                        ?>

                                        <?php if(($gateway->is_active == 0 && $gateway->is_enabled_to_use) || ($gateway->is_active == 1)): ?>
                                            <form action="<?php echo e(route('admin.third-party.payment-method.payment-status')); ?>" method="post"
                                                  id="payment-<?php echo e($gateway->key_name); ?>-status-form">
                                                <?php echo csrf_field(); ?>
                                                <input name="key_name" value="<?php echo e($gateway->key_name); ?>" hidden>
                                                <label class="switcher" for="payment-<?php echo e($gateway->key_name); ?>-status">
                                                    <input
                                                        class="switcher_input custom-modal-plugin"
                                                        type="checkbox" value="1" name="status"
                                                        id="payment-<?php echo e($gateway->key_name); ?>-status"
                                                        <?php echo e($gateway['is_active'] == 1 ? 'checked' : ''); ?>

                                                        data-modal-type="input-change-form"
                                                        data-modal-form="#payment-<?php echo e($gateway->key_name); ?>-status-form"
                                                        data-on-image="<?php echo e($img_path); ?>"
                                                        data-off-image="<?php echo e($img_path); ?>"
                                                        data-on-title="<?php echo e(translate('want_to_Turn_ON_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                                        data-off-title="<?php echo e(translate('want_to_Turn_OFF_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                                        data-on-message="<p><?php echo e(translate('if_enabled_customers_can_use_this_payment_method')); ?></p>"
                                                        data-off-message="<p><?php echo e(translate('if_disabled_this_payment_method_will_be_hidden_from_the_checkout_page')); ?></p>">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </form>
                                        <?php else: ?>
                                            <label class="switcher" data-bs-toggle="modal" data-bs-target="#gateway-modal-<?php echo e($gateway['key_name']); ?>">
                                                <input class="switcher_input" type="checkbox" name="status" value="1" disabled
                                                    id="<?php echo e($gateway->key_name); ?>" <?php echo e($gateway['is_active'] == 1?'checked':''); ?>

                                                    data-modal-id="toggle-modal"
                                                    data-toggle-id="<?php echo e($gateway->key_name); ?>"
                                                    data-on-image="<?php echo e($img_path); ?>"
                                                    data-off-image="<?php echo e($img_path); ?>"
                                                    data-on-title="<?php echo e(translate('want_to_Turn_ON_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                                    data-off-title="<?php echo e(translate('want_to_Turn_OFF_')); ?><?php echo e(str_replace('_',' ',strtoupper($gateway->key_name))); ?><?php echo e(translate('_as_the_Digital_Payment_method').'?'); ?>"
                                                    data-on-message="<p><?php echo e(translate('if_enabled_customers_can_use_this_payment_method')); ?></p>"
                                                    data-off-message="<p><?php echo e(translate('if_disabled_this_payment_method_will_be_hidden_from_the_checkout_page')); ?></p>">
                                                <span class="switcher_control" data-ontitle="<?php echo e(translate('on')); ?>" data-offtitle="<?php echo e(translate('off')); ?>"></span>
                                            </label>
                                        <?php endif; ?>

                                        <button class="btn btn-outline-warning btn-outline-warning-dark icon-btn" data-bs-toggle="offcanvas" data-bs-target="#offcanvas-<?php echo e($gateway->key_name); ?>">
                                            <i class="fi fi-sr-settings"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php if(!(($gateway->is_active == 0 && $gateway->is_enabled_to_use) || ($gateway->is_active == 1 && $gateway->must_required_for_currency != 1))): ?>
                            <div class="modal fade" id="gateway-modal-<?php echo e($gateway['key_name']); ?>" tabindex="-1" aria-labelledby="toggle-modal" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content shadow-lg">
                                        <div class="modal-header border-0 pb-0 d-flex justify-content-end">
                                            <button type="button" class="btn-close border-0" data-bs-dismiss="modal" aria-label="Close">
                                                <i class="tio-clear"></i>
                                            </button>
                                        </div>
                                        <div class="modal-body px-4 px-sm-5 pt-0">
                                            <div class="d-flex flex-column align-items-center text-center gap-2 mb-2">
                                                <div class="toggle-modal-img-box d-flex flex-column justify-content-center align-items-center mb-3 position-relative">
                                                    <?php if($gateway['is_active'] == 1): ?>
                                                        <img src="<?php echo e(getValidImage(path: 'payment-gateway-off.png', type: 'banner', source: asset('public/assets/back-end/img/modal/payment-gateway-off.png'))); ?>" class="status-icon"  alt="" width="80"/>
                                                    <?php else: ?>
                                                        <img src="<?php echo e(getValidImage(path: 'payment-gateway-on.png', type: 'banner', source: asset('public/assets/back-end/img/modal/payment-gateway-on.png'))); ?>" class="status-icon"  alt="" width="80"/>
                                                    <?php endif; ?>
                                                    <img src="" alt="" />
                                                </div>
                                                <h5 class="modal-title">
                                                    <?php echo e(translate('Are_you_sure')); ?>, <?php echo e(translate('want_to_turn_'. ($gateway['is_active'] == 1 ? 'Off' : 'ON').'_'.$gateway['key_name'] .'_as_the_Digital_Payment_method')); ?>?
                                                </h5>
                                                <div class="text-center">
                                                    <?php echo e(translate('If_you_enable_this_payment_gateway_please_check_in_currency_settings_that_currency_support_this_gateway_or_not')); ?>!
                                                </div>
                                                <div class="text-center py-3">
                                                    <a class="text-underline font-weight-bold" href="<?php echo e(route('admin.system-setup.currency.view')); ?>">
                                                        <?php echo e(translate('Go_to_currency_settings')); ?>

                                                    </a>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-center gap-3 mt-3">
                                                <button type="button" class="btn btn--primary min-w-120" data-bs-dismiss="modal">
                                                    <?php echo e(translate('ok')); ?>

                                                </button>
                                                <button type="button" class="btn btn-danger-light min-w-120" data-bs-dismiss="modal">
                                                    <?php echo e(translate('cancel')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="empty-state-for-payment d-none">
                            <?php echo $__env->make('layouts.admin.partials._empty-state',['text'=>'no_payment_method_found'],['image'=>'offline-payment', 'width' => 60], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                </div>
            </div>
        </div>

        <?php $__currentLoopData = $paymentGatewaysList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make("admin-views.third-party.payment-method._payment-gateways-offcanvas", ['gateway' => $gateway], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php echo $__env->make("layouts.admin.partials.offcanvas._digital-payment-setup", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(dynamicAsset(path: 'public/assets/new/back-end/js/payment-method-setup.js')); ?>"></script>
    <script>
        'use strict';
        <?php if($paymentGatewayPublishedStatus): ?>
            let paymentGatewayCards = $('#payment-gateway-cards');
            paymentGatewayCards.find('input').each(function () {
                $(this).attr('disabled', true);
            });
            paymentGatewayCards.find('select').each(function () {
                $(this).attr('disabled', true);
            });
            paymentGatewayCards.find('.switcher_input').each(function () {
                $(this).removeAttr('checked', true);
            });
            paymentGatewayCards.find('button').each(function () {
                $(this).attr('disabled', true);
            });
        <?php endif; ?>
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Crowdfunding1\E-Africal Mall org\resources\views/admin-views/third-party/payment-method/index.blade.php ENDPATH**/ ?>