<?php if($method): ?>
        <?php
        $productPriceTotal = 0;
        $totalTax = 0;
        $totalShippingCost = 0;
        $orderWiseShippingDiscount = \App\Utils\CartManager::order_wise_shipping_discount();
        $totalDiscountOnProduct = 0;
        $cart = \App\Utils\CartManager::getCartListQuery(type: 'checked');
        $shippingCost = \App\Utils\CartManager::get_shipping_cost(type: 'checked');
        $getShippingCostSavedForFreeDelivery = \App\Utils\CartManager::getShippingCostSavedForFreeDelivery();
        $couponDiscount = session()->has('coupon_discount') ? session('coupon_discount') : 0;
        if ($cart->count() > 0) {
            foreach ($cart as $key => $cartItem) {
                $productPriceTotal += $cartItem['price'] * $cartItem['quantity'];
                $totalTax += $cartItem['tax_model'] == 'exclude' ? ($cartItem['tax'] * $cartItem['quantity']) : 0;
                $totalDiscountOnProduct += $cartItem['discount'] * $cartItem['quantity'];
            }

            if (session()->missing('coupon_type') || session('coupon_type') != 'free_delivery') {
                $totalShippingCost = $shippingCost - $getShippingCostSavedForFreeDelivery;
            } else {
                $totalShippingCost = $shippingCost;
            }

            $totalOfflineAmount = $productPriceTotal + $totalTax + $totalShippingCost - $couponDiscount - $totalDiscountOnProduct - $orderWiseShippingDiscount;
        }
        ?>

    <div class="payment-list-area">

        <div class="bg-primary-light rounded p-4 mt-4 mx-xl-5">
            <h6 class="text-capitalize"><?php echo e($method['method_name']); ?> <?php echo e(translate('info')); ?></h6>
            <div class="row g-2 fs-12">
                <?php $__currentLoopData = $method['method_fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $methodField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-5 col-sm-6">
                        <div class="d-flex gap-2">
                            <span class="text-muted text-capitalize"><?php echo e(translate($methodField['input_name'])); ?></span>
                            : <span class="text-dark"><?php echo e(translate($methodField['input_data'])); ?></span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <h4 class="mt-4 font-weight-bold text-center">
            <?php echo e(translate('amount')); ?> : <?php echo e(webCurrencyConverter(amount: $totalOfflineAmount)); ?>

        </h4>

        <div class="mx-xl-5">
            <div class="row">
                <input type="hidden" value="offline_payment" name="payment_method">
                <input type="hidden" value="<?php echo e($method['id']); ?>" name="method_id">
                    <?php
                    $count = count($method['method_informations']);
                    $count_status = $count % 2 == 1 ? 'odd' : 'even';
                    ?>
                <?php $__currentLoopData = $method['method_informations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $information): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-<?php echo e($key == 0 && $count_status==="odd" ? 12 : 6); ?>">
                        <div class="form-group">
                            <label for="payment_by"><?php echo e(translate($information['customer_input'])); ?>

                                <span class="text-danger"><?php echo e($information['is_required'] == 1?'*':''); ?></span>
                            </label>
                            <input type="text" name="<?php echo e($information['customer_input']); ?>" class="form-control"
                                   placeholder="<?php echo e(translate($information['customer_placeholder'])); ?>" <?php echo e($information['is_required'] == 1?'required':''); ?>>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="col-12">
                    <div class="form-group">
                        <label for="account_no"><?php echo e(translate('payment_note')); ?></label>
                        <textarea class="form-control" name="payment_note" rows="4"
                                  placeholder="<?php echo e(translate('insert_note')); ?>"></textarea>
                    </div>
                </div>
                <div class="col-12">
                    <div class="d-flex justify-content-end gap-3">
                        <button type="button" class="btn btn-secondary form-cancel-button" data-dismiss="modal">
                            <?php echo e(translate('close')); ?>

                        </button>
                        <button type="submit" class="btn btn--primary px-4 form-loading-button">
                            <span class="spinner-grow spinner-grow-sm" aria-hidden="true"></span>
                            <span class="loading"><?php echo e(translate('Loading')); ?>...</span>
                            <span class="default"><?php echo e(translate('submit')); ?></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH C:\laragon\www\Crowdfunding1\E-Africal Mall org\resources\themes\default/web-views/partials/_pay-offline-method-list-field.blade.php ENDPATH**/ ?>